void PlaySound (const u16* DataPtr)
{
  // Sets up a sound to play. If there are too many sounds playing, the sound
  // will not play.

  unsigned int i;  // Loop counter for finding a free sound.

  for(i = 0; i < kMaxSounds; i++)
  {
    if(!Sound[i].StartPtr)
    {
      Sound[i].StartPtr = (u16*)(DataPtr + 1);
      Sound[i].NoteIndex = -1;
      Sound[i].FramesPerNote = Sound[i].FramesLeft = *DataPtr;

      break;
    }
  }
}

void StopSound (unsigned char SoundIndex)
{
  // Stops a sound.

  // Mark it as nonexistant.
  Sound[SoundIndex].StartPtr = 0;
  
  // Make it silent.
  SND_REGS[SoundIndex].SxLRV = 0;
}

void StopAllSounds ()
{
u8 instrument1=0, instrument2=0, instrument3=0;


  // Stops all sounds.

  unsigned int i;  // Loop counter.

  for(i = 0; i < kMaxSounds; i++) StopSound(i);
}

void PauseAllSounds ()
{
  // Pauses all sounds by making them silent.
  // Maybe we should use SSTOP instead?

  unsigned int i;  // Loop counter.

  for(i = 0; i < kMaxSounds; i++) SND_REGS[i].SxLRV = 0;
}

void DoSounds ()
{
  // Changes notes on sounds if necessary or ends them.


  unsigned char i;      // Loop counter.
  unsigned short Note;  // Temporary variable for holding the next note.

  for(i = 0; i < kMaxSounds; i++)
  {
    if(Sound[i].StartPtr)
    {
      if(!(--Sound[i].FramesLeft))
      {
        Sound[i].NoteIndex++;                          // Move to next note.
        Note = Sound[i].StartPtr[Sound[i].NoteIndex];  // Get it.

        // Set length of new note.
        Sound[i].FramesLeft = Sound[i].FramesPerNote;




        // Is it a special note?
        switch(Note)
        {
          case PAU:
            // Pause.
            SND_REGS[i].SxLRV = 0;
            continue;
        
          case HOLD:
            // Continue playing the previous note.
            continue;

          case ENDSOUND:
            // End the sound.
            StopSound(i);
            continue;

          case LOOPSOUND:
            // Restart the sound.
            Sound[i].NoteIndex = -1;  // Will get incremented next time.
            Sound[i].FramesLeft = 1;  // Will get decremented next time.
            continue;
        }

        // Send the note to the sound channel.
        SND_REGS[i].SxINT = 0x9F;         // I don't know what this is for.
        SND_REGS[i].SxFQH = Note >> 8;    // Frequency; higher 3 bits.
        SND_REGS[i].SxFQL = Note & 0xFF;  // Frequency; lower 8 bits.
        SND_REGS[i].SxLRV = 0xFF;         // Left/right speaker volume.
        SND_REGS[i].SxEV0 = 0xFC;         // No fadeout; volume is constant.
        SND_REGS[i].SxEV1 = 0x02;         // Repeat it forever.
      }
    }
  }
}

void InitSound ()
{
  // Sets up the VSU for use with the sound engine.
  
  unsigned int i;  // Loop counter for generating a square waveform.

  // Silence.
  //SSTOP = 1;
  
  // Modulation data. I don't know what this is, but it seems to be necessary.
  for(i = 0; i <= 0x7C; i++) MODDATA[i << 2] = kModData[i];
  
  // Make a square waveform.
  for(i = 0; i <= 0x3C; i += 4) WAVEDATA1[i] = 0;        // The low part.
  for(i = 0x40; i <= 0x7C; i += 4) WAVEDATA1[i] = 0x3F;  // The high part.
    
  // Choose the same waveform for all channels.
  SND_REGS[WAVE1].SxRAM = 0;
  SND_REGS[WAVE2].SxRAM = 0;
  SND_REGS[WAVE3].SxRAM = 0;
  SND_REGS[WAVE4].SxRAM = 0;
}
